(function() {
    'use strict';
    
    document.addEventListener('DOMContentLoaded', initShortcutsToggle);
    
    function initShortcutsToggle() {
        const toggleBtn = document.querySelector('.shortcuts-toggle-btn');
        const container = document.querySelector('.shortcuts-container');
        
        if (!toggleBtn || !container) {
            return;
        }
        
        const savedState = localStorage.getItem('shortcutsCompact');
        if (savedState === 'true') {
            container.classList.add('compact');
            updateButtonIcon(toggleBtn, true);
        }
        
        toggleBtn.addEventListener('click', function(e) {
            e.preventDefault();
            const isCompact = container.classList.contains('compact');
            
            if (isCompact) {
                container.classList.remove('compact');
                localStorage.setItem('shortcutsCompact', 'false');
                updateButtonIcon(toggleBtn, false);
            } else {
                container.classList.add('compact');
                localStorage.setItem('shortcutsCompact', 'true');
                updateButtonIcon(toggleBtn, true);
            }
        });
    }
    
    function updateButtonIcon(btn, isCompact) {
        const icon = btn.querySelector('i');
        if (icon) {
            if (isCompact) {
                icon.className = 'glyphicon glyphicon-resize-full';
            } else {
                icon.className = 'glyphicon glyphicon-resize-small';
            }
        }
    }
})();
