<!DOCTYPE html>
<html>
<head>
    <title>License Check</title>
    <style>
        #license-banner {
            padding: 10px;
            text-align: center;
            font-weight: bold;
            color: white;
        }
        .valid { background-color: #4CAF50; }
        .invalid { background-color: #f44336; }
        .checking { background-color: #ff9800; }
    </style>
</head>
<body>
    <div id="license-banner" class="checking">
        🔄 Checking license...
    </div>

    <script>
        const SECRET_KEY = 'hdwfQCgYV4SXMERs-KGl57_crimN-iPaT0zIOfeo7Zw';

        function verifySignature(data, signature) {
            // Note: HMAC verification in JavaScript requires crypto library
            // For now, we'll skip signature verification in browser
            // Signature is verified on activation only
            return true;
        }

        async function checkLicense() {
            const banner = document.getElementById('license-banner');
            
            try {
                const response = await fetch('http://localhost:5050/check_license');
                
                if (!response.ok) {
                    throw new Error('Server not reachable');
                }
                
                const data = await response.json();
                
                // Check if license is valid
                if (data.status === 'active' && data.details.valid) {
                    banner.className = 'valid';
                    banner.innerHTML = `✓ ${data.message}`;
                    
                    // Send valid status to PHP session
                    await fetch('save_license_status.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ valid: true, data: data })
                    });
                    
                    return true;
                } else {
                    banner.className = 'invalid';
                    banner.innerHTML = `✗ ${data.message}`;
                    
                    // Redirect to license error page after 3 seconds
                    setTimeout(() => {
                        window.location.href = 'license_error.php';
                    }, 3000);
                    
                    return false;
                }
            } catch (error) {
                banner.className = 'invalid';
                banner.innerHTML = '✗ License Server Not Running - Please start the Elbaset License Manager on your computer';
                
                // Redirect to license error page after 5 seconds
                setTimeout(() => {
                    window.location.href = 'license_error.php';
                }, 5000);
                
                return false;
            }
        }

        // Check license on page load
        checkLicense();
        
        // Re-check every 5 minutes
        setInterval(checkLicense, 300000);
    </script>
</body>
</html>
