<?php
header('Content-Type: application/json');
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    echo json_encode(['error' => 'Invalid request method']);
    exit;
}

$hardware_id = $_GET['hardware_id'] ?? null;

if (!$hardware_id) {
    echo json_encode(['status' => 'error', 'message' => 'Hardware ID is required']);
    exit;
}

try {
    $stmt = $conn->prepare("SELECT * FROM licenses WHERE hardware_id = ? ORDER BY created_at DESC LIMIT 1");
    $stmt->execute([$hardware_id]);
    $license = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$license) {
        echo json_encode([
            'status' => 'not_found',
            'message' => 'No license found for this hardware ID'
        ]);
        exit;
    }
    
    if ($license['license_type'] == 'lifetime') {
        echo json_encode([
            'status' => 'active',
            'message' => 'Valid lifetime license',
            'license' => [
                'type' => 'lifetime',
                'key' => $license['license_key']
            ]
        ]);
    } else {
        $expiry = strtotime($license['expiry_date']);
        if (time() > $expiry) {
            echo json_encode([
                'status' => 'expired',
                'message' => 'License has expired',
                'license' => [
                    'type' => 'temporary',
                    'expiry_date' => $license['expiry_date']
                ]
            ]);
        } else {
            $days_left = floor(($expiry - time()) / 86400);
            echo json_encode([
                'status' => 'active',
                'message' => "Valid license - $days_left days remaining",
                'license' => [
                    'type' => 'temporary',
                    'expiry_date' => $license['expiry_date'],
                    'days_remaining' => $days_left
                ]
            ]);
        }
    }
} catch(PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
