<?php
session_start();
require_once 'auth_check.php';
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] == 'add') {
        $stmt = $pdo->prepare("INSERT INTO clients (client_name, company_name, email, phone, address, notes, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_POST['client_name'],
            $_POST['company_name'],
            $_POST['email'],
            $_POST['phone'],
            $_POST['address'],
            $_POST['notes'],
            $_SESSION['user_id']
        ]);
        $success = "Client added successfully!";
    } elseif ($_POST['action'] == 'edit') {
        $stmt = $pdo->prepare("UPDATE clients SET client_name=?, company_name=?, email=?, phone=?, address=?, notes=? WHERE id=?");
        $stmt->execute([
            $_POST['client_name'],
            $_POST['company_name'],
            $_POST['email'],
            $_POST['phone'],
            $_POST['address'],
            $_POST['notes'],
            $_POST['client_id']
        ]);
        $success = "Client updated successfully!";
    } elseif ($_POST['action'] == 'delete') {
        $stmt = $pdo->prepare("DELETE FROM clients WHERE id=?");
        $stmt->execute([$_POST['client_id']]);
        $success = "Client deleted successfully!";
    }
}

$clients = $pdo->query("SELECT c.*, u.full_name as created_by_name FROM clients c LEFT JOIN users u ON c.created_by = u.id ORDER BY c.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Management</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
        }
        .navbar {
            background: #667eea;
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .navbar h1 {
            font-size: 24px;
        }
        .navbar a {
            color: white;
            text-decoration: none;
            margin-left: 20px;
            padding: 8px 15px;
            border-radius: 5px;
            background: rgba(255,255,255,0.2);
        }
        .navbar a:hover {
            background: rgba(255,255,255,0.3);
        }
        .container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 0 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .btn {
            padding: 10px 20px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        .btn:hover {
            background: #5568d3;
        }
        .btn-danger {
            background: #dc3545;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .btn-small {
            padding: 5px 10px;
            font-size: 14px;
            margin: 0 5px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            background: white;
            border-radius: 5px;
            overflow: hidden;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background: #667eea;
            color: white;
        }
        tr:hover {
            background: #f9f9f9;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
        }
        .modal-content {
            background: white;
            margin: 50px auto;
            padding: 30px;
            border-radius: 10px;
            width: 90%;
            max-width: 600px;
        }
        .close {
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input, textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        textarea {
            resize: vertical;
            min-height: 80px;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>Elbaset Programme - License System</h1>
        <div>
            <span style="color: white; margin-right: 15px;">👤 <?php echo htmlspecialchars($_SESSION['full_name']); ?></span>
            <a href="index.php">Dashboard</a>
            <a href="clients.php">Clients</a>
            <a href="licenses.php">Licenses</a>
            <?php if ($_SESSION['user_role'] == 'admin'): ?>
            <a href="users.php">Users</a>
            <?php endif; ?>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="header">
            <h2>Client Management</h2>
            <button class="btn" onclick="openAddModal()">Add New Client</button>
        </div>

        <?php if (isset($success)): ?>
            <div class="success"><?php echo $success; ?></div>
        <?php endif; ?>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Client Name</th>
                    <th>Company</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Created By</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($clients as $client): ?>
                <tr>
                    <td><?php echo $client['id']; ?></td>
                    <td><?php echo htmlspecialchars($client['client_name']); ?></td>
                    <td><?php echo htmlspecialchars($client['company_name']); ?></td>
                    <td><?php echo htmlspecialchars($client['email']); ?></td>
                    <td><?php echo htmlspecialchars($client['phone']); ?></td>
                    <td><?php echo htmlspecialchars($client['created_by_name']); ?></td>
                    <td><?php echo date('Y-m-d', strtotime($client['created_at'])); ?></td>
                    <td>
                        <button class="btn btn-small" onclick='openEditModal(<?php echo json_encode($client); ?>)'>Edit</button>
                        <a href="licenses.php?client_id=<?php echo $client['id']; ?>" class="btn btn-small">View Licenses</a>
                        <form method="POST" style="display:inline;" onsubmit="return confirm('Delete this client and all associated licenses?');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="client_id" value="<?php echo $client['id']; ?>">
                            <button type="submit" class="btn btn-small btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div id="clientModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 id="modalTitle">Add New Client</h2>
            <form method="POST" id="clientForm">
                <input type="hidden" name="action" id="formAction" value="add">
                <input type="hidden" name="client_id" id="clientId">
                
                <div class="form-group">
                    <label>Client Name *</label>
                    <input type="text" name="client_name" id="clientName" required>
                </div>
                
                <div class="form-group">
                    <label>Company Name</label>
                    <input type="text" name="company_name" id="companyName">
                </div>
                
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" id="email">
                </div>
                
                <div class="form-group">
                    <label>Phone</label>
                    <input type="text" name="phone" id="phone">
                </div>
                
                <div class="form-group">
                    <label>Address</label>
                    <textarea name="address" id="address"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Notes</label>
                    <textarea name="notes" id="notes"></textarea>
                </div>
                
                <button type="submit" class="btn">Save Client</button>
            </form>
        </div>
    </div>

    <script>
        function openAddModal() {
            document.getElementById('modalTitle').innerText = 'Add New Client';
            document.getElementById('formAction').value = 'add';
            document.getElementById('clientForm').reset();
            document.getElementById('clientModal').style.display = 'block';
        }

        function openEditModal(client) {
            document.getElementById('modalTitle').innerText = 'Edit Client';
            document.getElementById('formAction').value = 'edit';
            document.getElementById('clientId').value = client.id;
            document.getElementById('clientName').value = client.client_name;
            document.getElementById('companyName').value = client.company_name;
            document.getElementById('email').value = client.email;
            document.getElementById('phone').value = client.phone;
            document.getElementById('address').value = client.address;
            document.getElementById('notes').value = client.notes;
            document.getElementById('clientModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('clientModal').style.display = 'none';
        }

        window.onclick = function(event) {
            if (event.target == document.getElementById('clientModal')) {
                closeModal();
            }
        }
    </script>
</body>
</html>
