<?php
require_once 'config.php';

echo "<h2>Database Debug</h2>";
echo "<pre>";

try {
    // Check if users table exists
    $tables = $pdo->query("SHOW TABLES LIKE 'users'")->fetchAll();
    if (count($tables) == 0) {
        echo "❌ ERROR: 'users' table does NOT exist!\n\n";
        echo "You need to run this SQL first:\n";
        echo "mysql -u root -p license_system < database/schema_with_users.sql\n\n";
        
        echo "Or run this in phpMyAdmin/MySQL:\n";
        echo file_get_contents('../database/schema_with_users.sql');
        exit;
    }
    
    echo "✓ 'users' table exists\n\n";
    
    // Check users
    $users = $pdo->query("SELECT id, username, full_name, role, is_active FROM users")->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($users) == 0) {
        echo "❌ No users found in database!\n\n";
        echo "Creating admin user now...\n\n";
        
        $username = 'admin';
        $password = 'password';
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("INSERT INTO users (username, password, full_name, email, role, is_active) VALUES (?, ?, ?, ?, ?, 1)");
        $stmt->execute([$username, $hashed, 'Administrator', 'admin@elbaset.com', 'admin']);
        
        echo "✓ Admin user created!\n\n";
        echo "Username: admin\n";
        echo "Password: password\n\n";
        echo "<a href='login_new.php'>Go to Login</a>";
    } else {
        echo "✓ Found " . count($users) . " user(s):\n\n";
        print_r($users);
        
        echo "\n\nTesting password verification...\n";
        $test_user = $pdo->prepare("SELECT * FROM users WHERE username = 'admin'");
        $test_user->execute();
        $user = $test_user->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            echo "\nAdmin user found:\n";
            echo "ID: " . $user['id'] . "\n";
            echo "Username: " . $user['username'] . "\n";
            echo "Is Active: " . ($user['is_active'] ? 'Yes' : 'No') . "\n";
            
            $test_pass = password_verify('password', $user['password']);
            echo "\nPassword 'password' verification: " . ($test_pass ? '✓ CORRECT' : '❌ WRONG') . "\n";
            
            if (!$test_pass) {
                echo "\nResetting password to 'password'...\n";
                $new_hash = password_hash('password', PASSWORD_DEFAULT);
                $update = $pdo->prepare("UPDATE users SET password = ? WHERE username = 'admin'");
                $update->execute([$new_hash]);
                echo "✓ Password reset complete!\n";
            }
        } else {
            echo "❌ Admin user not found!\n";
        }
    }
    
} catch (PDOException $e) {
    echo "❌ Database Error: " . $e->getMessage() . "\n";
}

echo "</pre>";
?>
