<?php
function generateLicenseKey($hardware_id, $license_type, $duration = null) {
    $hw_hash = substr($hardware_id, 0, 16);
    
    if ($license_type == 'lifetime') {
        $license_key = $hw_hash . '-LIFETIME-' . strtoupper(bin2hex(random_bytes(8)));
    } else {
        $expiry = date('Ymd', strtotime("+$duration"));
        $license_key = $hw_hash . '-TEMP-' . $expiry . '-' . strtoupper(bin2hex(random_bytes(4)));
    }
    
    return $license_key;
}

function saveLicense($conn, $hardware_id, $license_key, $license_type, $expiry_date = null) {
    $stmt = $conn->prepare("INSERT INTO licenses (hardware_id, license_key, license_type, expiry_date) VALUES (?, ?, ?, ?)");
    $stmt->execute([$hardware_id, $license_key, $license_type, $expiry_date]);
    return $conn->lastInsertId();
}

function getAllLicenses($conn) {
    $stmt = $conn->query("SELECT * FROM licenses ORDER BY created_at DESC");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getLicenseStatus($license) {
    if ($license['license_type'] == 'lifetime') {
        return 'Active';
    }
    
    if ($license['expiry_date']) {
        $expiry = strtotime($license['expiry_date']);
        if (time() > $expiry) {
            return 'Expired';
        }
        return 'Active';
    }
    
    return 'Unknown';
}
?>
