<?php
session_start();
require_once 'config.php';
require_once 'functions.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$success = false;
$generated_license = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hardware_id = trim($_POST['hardware_id']);
    $license_type = $_POST['license_type'];
    $duration = $_POST['duration'] ?? null;
    
    $expiry_date = null;
    if ($license_type != 'lifetime' && $duration) {
        $expiry_date = date('Y-m-d', strtotime("+$duration"));
    }
    
    $license_key = generateLicenseKey($hardware_id, $license_type, $duration);
    saveLicense($conn, $hardware_id, $license_key, $license_type, $expiry_date);
    
    $success = true;
    $generated_license = $license_key;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate License</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        input, select, textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        textarea {
            resize: vertical;
            min-height: 80px;
        }
        .btn {
            padding: 12px 30px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-right: 10px;
        }
        .btn:hover {
            background: #0056b3;
        }
        .btn-secondary {
            background: #6c757d;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
        }
        .license-display {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-top: 10px;
            word-break: break-all;
            font-family: monospace;
        }
        .duration-field {
            display: none;
        }
    </style>
    <script>
        function toggleDuration() {
            const licenseType = document.getElementById('license_type').value;
            const durationField = document.getElementById('duration-field');
            
            if (licenseType === 'lifetime') {
                durationField.style.display = 'none';
            } else {
                durationField.style.display = 'block';
            }
        }
        
        function copyLicense() {
            const licenseText = document.getElementById('license-text').innerText;
            navigator.clipboard.writeText(licenseText);
            alert('License key copied to clipboard!');
        }
    </script>
</head>
<body>
    <div class="container">
        <h1>Generate New License</h1>
        
        <?php if ($success): ?>
            <div class="success">
                <strong>License Generated Successfully!</strong>
                <div class="license-display" id="license-text"><?php echo $generated_license; ?></div>
                <button onclick="copyLicense()" class="btn" style="margin-top: 10px;">Copy License Key</button>
            </div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="hardware_id">Hardware ID *</label>
                <textarea id="hardware_id" name="hardware_id" required placeholder="Paste the hardware ID from the client application"></textarea>
            </div>
            
            <div class="form-group">
                <label for="license_type">License Type *</label>
                <select id="license_type" name="license_type" onchange="toggleDuration()" required>
                    <option value="lifetime">Lifetime</option>
                    <option value="temporary">Temporary</option>
                </select>
            </div>
            
            <div class="form-group duration-field" id="duration-field">
                <label for="duration">Duration *</label>
                <select id="duration" name="duration">
                    <option value="1 month">1 Month</option>
                    <option value="3 months">3 Months</option>
                    <option value="6 months">6 Months</option>
                    <option value="1 year">1 Year</option>
                    <option value="2 years">2 Years</option>
                </select>
            </div>
            
            <button type="submit" class="btn">Generate License</button>
            <a href="index.php" class="btn btn-secondary">Back to List</a>
        </form>
    </div>
</body>
</html>
