<?php
session_start();
$error_message = isset($_SESSION['license_message']) ? $_SESSION['license_message'] : 'License validation failed';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Error</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .error-container {
            background: white;
            padding: 50px;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            text-align: center;
            max-width: 500px;
        }
        .error-icon {
            font-size: 72px;
            color: #dc3545;
            margin-bottom: 20px;
        }
        h1 {
            color: #333;
            margin-bottom: 20px;
        }
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
        }
        .instructions {
            text-align: left;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .instructions h3 {
            margin-bottom: 10px;
            color: #667eea;
        }
        .instructions ol {
            margin-left: 20px;
        }
        .instructions li {
            margin-bottom: 10px;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 5px;
        }
        .btn:hover {
            background: #5568d3;
        }
        .btn-secondary {
            background: #6c757d;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">⚠</div>
        <h1>License Validation Error</h1>
        
        <div class="error-message">
            <?php echo htmlspecialchars($error_message); ?>
        </div>
        
        <div class="instructions">
            <h3>To resolve this issue:</h3>
            <ol>
                <li><strong>Start the License Server:</strong> Make sure the Python license server is running on this computer</li>
                <li><strong>Check License Status:</strong> Open the License Management application and verify your license is active</li>
                <li><strong>Contact Support:</strong> If your license has expired, contact your vendor to renew</li>
                <li><strong>Verify System Integrity:</strong> Ensure no tampering with license files or server communication</li>
            </ol>
        </div>
        
        <a href="javascript:location.reload()" class="btn">Retry</a>
        <a href="javascript:history.back()" class="btn btn-secondary">Go Back</a>
    </div>
    
    <script>
        setTimeout(function() {
            location.reload();
        }, 30000);
    </script>
</body>
</html>
