<?php

session_start();

define('SECRET_KEY', 'hdwfQCgYV4SXMERs-KGl57_crimN-iPaT0zIOfeo7Zw');

$recheck_interval = 300;

function verify_signature($data, $signature) {
    $data_copy = $data;
    unset($data_copy['signature']);
    
    ksort_recursive($data_copy);
    $message = json_encode($data_copy, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    
    $message = str_replace(': ', ':', $message);
    $message = str_replace(', ', ',', $message);
    
    $expected_signature = hash_hmac('sha256', $message, SECRET_KEY);
    
    return hash_equals($expected_signature, $signature);
}

function ksort_recursive(&$array) {
    if (!is_array($array)) return;
    ksort($array);
    foreach ($array as &$value) {
        if (is_array($value)) {
            ksort_recursive($value);
        }
    }
}

function check_license_secure() {
    global $recheck_interval;
    
    if (!isset($_SESSION['license_last_check']) || 
        (time() - $_SESSION['license_last_check']) > $recheck_interval) {
        
        $license_url = 'http://localhost:5050/check_license';
        
        $ch = curl_init($license_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $_SESSION['license_last_check'] = time();
        $_SESSION['license_valid'] = false;
        $_SESSION['license_message'] = 'License Server Not Reachable';
        
        if ($http_code == 200 && $response) {
            $data = json_decode($response, true);
            
            if (!isset($data['signature'])) {
                $_SESSION['license_message'] = 'Invalid License Response - Missing Signature';
                return false;
            }
            
            $signature = $data['signature'];
            
            if (!verify_signature($data, $signature)) {
                $_SESSION['license_message'] = 'Invalid License Response - Signature Verification Failed';
                error_log('LICENSE SECURITY WARNING: Signature verification failed! Possible tampering detected.');
                error_log('Response JSON: ' . json_encode($data));
                return false;
            }
            
            try {
                $response_time = new DateTime($data['timestamp'], new DateTimeZone('UTC'));
                $current_time = new DateTime('now', new DateTimeZone('UTC'));
                $diff = abs($current_time->getTimestamp() - $response_time->getTimestamp());
                
                if ($diff > 300) {
                    $_SESSION['license_message'] = 'Invalid License Response - Timestamp Too Old (' . $diff . 's)';
                    error_log('LICENSE SECURITY WARNING: Response timestamp is too old. Diff: ' . $diff . 's');
                    return false;
                }
            } catch (Exception $e) {
                $_SESSION['license_message'] = 'Invalid License Response - Invalid Timestamp';
                error_log('LICENSE ERROR: Could not parse timestamp: ' . $e->getMessage());
                return false;
            }
            
            if ($data['status'] == 'active' && isset($data['details']['valid']) && $data['details']['valid']) {
                $_SESSION['license_valid'] = true;
                $_SESSION['license_message'] = 'License Active - Type: ' . ucfirst($data['details']['type']);
                if ($data['details']['type'] == 'temporary') {
                    $_SESSION['license_message'] .= ' - Expires: ' . $data['details']['expiry'];
                }
                return true;
            } else {
                $_SESSION['license_message'] = 'License Error: ' . $data['message'];
                return false;
            }
        }
        
        return false;
    }
    
    return isset($_SESSION['license_valid']) && $_SESSION['license_valid'];
}

$is_valid = check_license_secure();

$banner_color = $is_valid ? '#4CAF50' : '#f44336';
$banner_text = isset($_SESSION['license_message']) ? $_SESSION['license_message'] : 'License Status Unknown';

echo '<div style="background-color: ' . $banner_color . '; color: white; padding: 10px; text-align: center; font-weight: bold;">';
echo htmlspecialchars($banner_text);
echo '</div>';

if (!$is_valid) {
    header('Location: license_error.php');
    exit;
}
?>
