<?php
// For WEB-BASED ERP - License stored in database, not client machine

session_start();

require_once 'config.php';

define('SECRET_KEY', 'hdwfQCgYV4SXMERs-KGl57_crimN-iPaT0zIOfeo7Zw');

$recheck_interval = 3600; // Check every hour

function check_server_license() {
    global $pdo, $recheck_interval;
    
    if (!isset($_SESSION['license_last_check']) || 
        (time() - $_SESSION['license_last_check']) > $recheck_interval) {
        
        // Check license from database (server-side license)
        $stmt = $pdo->prepare("SELECT * FROM system_license WHERE id = 1");
        $stmt->execute();
        $license = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $_SESSION['license_last_check'] = time();
        $_SESSION['license_valid'] = false;
        $_SESSION['license_message'] = 'No License Installed';
        
        if ($license) {
            // Check expiry
            if ($license['license_type'] == 'lifetime') {
                $_SESSION['license_valid'] = true;
                $_SESSION['license_message'] = 'License Active - Type: Lifetime';
                return true;
            } else {
                $expiry = strtotime($license['expiry_date']);
                if (time() < $expiry) {
                    $days_left = ceil(($expiry - time()) / 86400);
                    $_SESSION['license_valid'] = true;
                    $_SESSION['license_message'] = "License Active - Expires in $days_left days";
                    return true;
                } else {
                    $_SESSION['license_message'] = 'License Expired';
                    return false;
                }
            }
        }
        
        return false;
    }
    
    return isset($_SESSION['license_valid']) && $_SESSION['license_valid'];
}

$is_valid = check_server_license();

$banner_color = $is_valid ? '#4CAF50' : '#f44336';
$banner_text = isset($_SESSION['license_message']) ? $_SESSION['license_message'] : 'License Status Unknown';

echo '<div style="background-color: ' . $banner_color . '; color: white; padding: 10px; text-align: center; font-weight: bold;">';
echo htmlspecialchars($banner_text);
echo '</div>';

// Uncomment to enforce license
// if (!$is_valid) {
//     header('Location: license_error.php');
//     exit;
// }
?>
