<?php
define('SECRET_KEY', 'hdwfQCgYV4SXMERs-KGl57_crimN-iPaT0zIOfeo7Zw');

function ksort_recursive(&$array) {
    if (!is_array($array)) return;
    ksort($array);
    foreach ($array as &$value) {
        if (is_array($value)) {
            ksort_recursive($value);
        }
    }
}

$license_url = 'http://localhost:5050/check_license';

$ch = curl_init($license_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<h2>Testing License Signature Verification</h2>";
echo "<pre>";

if ($http_code == 200 && $response) {
    echo "Response received:\n";
    echo $response . "\n\n";
    
    $data = json_decode($response, true);
    
    if (!isset($data['signature'])) {
        echo "ERROR: No signature in response\n";
        exit;
    }
    
    $received_signature = $data['signature'];
    echo "Received Signature: " . $received_signature . "\n\n";
    
    $data_copy = $data;
    unset($data_copy['signature']);
    
    echo "Data before sorting:\n";
    print_r($data_copy);
    
    ksort_recursive($data_copy);
    
    echo "\nData after sorting:\n";
    print_r($data_copy);
    
    $message = json_encode($data_copy, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    echo "\nJSON message for HMAC (before compact):\n";
    echo $message . "\n\n";
    
    $message = str_replace(': ', ':', $message);
    $message = str_replace(', ', ',', $message);
    echo "JSON message for HMAC (after compact):\n";
    echo $message . "\n\n";
    
    $expected_signature = hash_hmac('sha256', $message, SECRET_KEY);
    echo "Computed Signature: " . $expected_signature . "\n";
    
    if (hash_equals($expected_signature, $received_signature)) {
        echo "\n✓ SUCCESS: Signatures match!\n";
    } else {
        echo "\n✗ FAILED: Signatures don't match!\n";
    }
} else {
    echo "ERROR: Could not connect to license server\n";
    echo "HTTP Code: " . $http_code . "\n";
}

echo "</pre>";
?>
